/*
 * Decompiled with CFR 0.152.
 */
package com.fortify.util.cmdline;

import com.fortify.io.UnicodeReader;
import com.fortify.messaging.Message;
import com.fortify.util.StringUtil;
import com.fortify.util.SystemUtil;
import com.fortify.util.Util;
import com.fortify.util.cmdline.Directive;
import com.fortify.util.cmdline.Qualifier;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Properties;
import java.util.regex.Pattern;

public class CommandLineParser {
    public static final String PROPERTY_SEPARATOR_TOKEN = ":";
    public static final Pattern PROPERTY_SEPARATOR_PATTERN = Pattern.compile(Pattern.quote(":"));
    public static final String OPTION_PREFIX = "-";
    protected Properties properties = new Properties();
    protected List<Directive> directives = new ArrayList<Directive>();
    protected List<Message> messages = new ArrayList<Message>();
    protected List<String> allOptions = new ArrayList<String>();
    private final String optionsFileEncoding;

    public CommandLineParser() {
        this.optionsFileEncoding = null;
    }

    public CommandLineParser(String optionsFileEncoding) {
        this.optionsFileEncoding = optionsFileEncoding;
    }

    public Properties getProperties() {
        return this.properties;
    }

    public List<? extends Directive> getDirectives() {
        return this.directives;
    }

    public List<Message> getMessages() {
        return this.messages;
    }

    public List<String> getAllOptions() {
        return this.allOptions;
    }

    public String[] doParse(String[] args, Qualifier.Group qualifiers, Directive errorDirective) {
        for (int idx = 0; idx < args.length; ++idx) {
            String arg = args[idx];
            if (arg.length() == 0) continue;
            if (arg.charAt(0) == '@') {
                String argFileName = arg.substring(1);
                try {
                    List<String> fileArgs = CommandLineParser.readArgsFromTempFile(argFileName, this.optionsFileEncoding);
                    String[] newArgs = new String[args.length + fileArgs.size() - 1];
                    System.arraycopy(args, 0, newArgs, 0, idx);
                    int n = idx;
                    for (String fileArg : fileArgs) {
                        newArgs[n++] = fileArg;
                    }
                    System.arraycopy(args, idx + 1, newArgs, n, newArgs.length - n);
                    args = newArgs;
                    --idx;
                }
                catch (IOException e) {
                    this.messages.add(new Message(4, 207, argFileName));
                }
                continue;
            }
            if (arg.charAt(0) == '-') {
                if (arg.startsWith("-D")) {
                    String val;
                    String key;
                    int eq = arg.indexOf(61);
                    if (eq != -1) {
                        key = arg.substring(2, eq);
                        val = arg.substring(eq + 1);
                    } else {
                        key = arg.substring(2);
                        val = "";
                    }
                    this.properties.setProperty(key, val);
                    Qualifier q = qualifiers.getForProperty(key);
                    if (q != null && q.arg != null) {
                        String filtered = this.handleOptArg(q, q.arg, val);
                        this.allOptions.add("-D" + key + "=" + filtered);
                        continue;
                    }
                    this.allOptions.add(arg);
                    continue;
                }
                this.allOptions.add(arg);
                String optionName = arg.substring(1);
                Qualifier q = qualifiers.getForOption(optionName);
                if (!(q != null || optionName.startsWith(OPTION_PREFIX) && (q = qualifiers.getForOption(arg.substring(2))) != null)) {
                    this.messages.add(new Message(4, 204, arg));
                    this.directives = new ArrayList<Directive>(Arrays.asList(errorDirective));
                    break;
                }
                this.qualifierPresent(q);
                if (q.arg == null) {
                    if (q.propertyName != null) {
                        this.properties.put(q.propertyName, "");
                    }
                } else {
                    if (++idx >= args.length) {
                        this.messages.add(new Message(4, 265, q.getOptionString()));
                        this.directives = new ArrayList<Directive>(Arrays.asList(errorDirective));
                        break;
                    }
                    String optArg = args[idx];
                    boolean ok = this.handleOptArg(q, optArg);
                    if (!ok) {
                        this.directives = new ArrayList<Directive>(Arrays.asList(errorDirective));
                        break;
                    }
                }
                if (!(q instanceof Qualifier.DirectiveQualifier)) continue;
                Qualifier.DirectiveQualifier dq = (Qualifier.DirectiveQualifier)Util.cast(q);
                if (!dq.task.isExclusive() && !this.directives.isEmpty() && this.directives.get(this.directives.size() - 1).isExclusive()) {
                    this.directives.add(this.directives.size() - 1, dq.task);
                    continue;
                }
                this.directives.add(dq.task);
                continue;
            }
            if (this.handleDefaultCase(args, idx)) break;
        }
        Iterator<Directive> it = this.directives.iterator();
        while (it.hasNext()) {
            Directive d = it.next();
            if (!d.isExclusive() || !it.hasNext()) continue;
            this.messages.add(new Message(4, 267, new Object[0]));
            this.directives = new ArrayList<Directive>(Arrays.asList(errorDirective));
            break;
        }
        return args;
    }

    protected void qualifierPresent(Qualifier q) {
    }

    protected boolean handleDefaultCase(String[] args, int idx) {
        this.allOptions.add(args[idx]);
        return false;
    }

    private boolean handleOptArg(Qualifier q, String arg) {
        if (arg.startsWith(OPTION_PREFIX)) {
            this.messages.add(new Message(4, 265, q.getOptionString()));
            return false;
        }
        Qualifier.Arg p = q.arg;
        assert (p != null);
        String filtered = this.handleOptArg(q, p, arg);
        if (filtered == null) {
            return false;
        }
        this.allOptions.add(filtered);
        if (q instanceof Qualifier.DirectiveQualifier) {
            assert (p instanceof Qualifier.Arg.Single);
            try {
                ((Qualifier.DirectiveQualifier)q).task.setArgument(arg);
            }
            catch (IllegalArgumentException e) {
                this.messages.add(new Message(4, 264, arg, q.getOptionString()));
                return false;
            }
        } else if (p instanceof Qualifier.Arg.List) {
            Qualifier.Arg.List pl = (Qualifier.Arg.List)Util.cast(p);
            String value = arg;
            String existing = this.properties.getProperty(q.propertyName);
            if (existing != null) {
                value = existing + pl.joinDelimiter + arg;
            }
            this.properties.setProperty(q.propertyName, value);
        } else {
            if (this.properties.containsKey(q.propertyName)) {
                this.messages.add(new Message(4, 266, arg, q.getOptionString()));
                return false;
            }
            this.properties.setProperty(q.propertyName, arg);
        }
        return true;
    }

    private String handleOptArg(Qualifier q, Qualifier.Arg p, String arg) {
        if (p instanceof Qualifier.Arg.List) {
            Qualifier.Arg.List pl = (Qualifier.Arg.List)Util.cast(p);
            String[] parts = pl.splitDelimiter.split(arg);
            StringBuilder filtered = new StringBuilder();
            for (String part : parts) {
                String filteredPart = this.handleOptArg(q, pl.element, part);
                filtered.append(filteredPart);
                filtered.append(pl.joinDelimiter);
            }
            if (filtered.length() > 0) {
                filtered.setLength(filtered.length() - pl.joinDelimiter.length());
            }
            return filtered.toString();
        }
        if (p instanceof Qualifier.Arg.Raw) {
            return arg;
        }
        if (p instanceof Qualifier.Arg.Enum) {
            Qualifier.Arg.Enum ep = (Qualifier.Arg.Enum)Util.cast(p);
            if (!ep.isValidOption(arg)) {
                this.messages.add(new Message(4, 264, arg, q.getOptionString()));
                return null;
            }
            return arg;
        }
        if (p instanceof Qualifier.Arg.Path) {
            return new File(arg).getAbsolutePath();
        }
        throw Util.badType(p);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<String> readArgsFromTempFile(String tempFile, String encoding) throws IOException {
        LinkedList<String> args = new LinkedList<String>();
        try (BufferedReader in = null;){
            String line;
            in = new BufferedReader(new UnicodeReader(new FileInputStream(tempFile), encoding));
            while ((line = in.readLine()) != null) {
                String[] lineArgs = StringUtil.parseArguments(line, SystemUtil.isWindows());
                args.addAll(Arrays.asList(lineArgs));
            }
            LinkedList<String> linkedList = args;
            return linkedList;
        }
    }

    public static List<String> readArgsFromTempFile(String tempFile) throws IOException {
        return CommandLineParser.readArgsFromTempFile(tempFile, null);
    }
}

