/*
 * Decompiled with CFR 0.152.
 */
package com.fortify.util.cmdline;

import com.fortify.util.StringUtil;
import com.fortify.util.cmdline.CommandLineParser;
import com.fortify.util.cmdline.Directive;
import java.io.File;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;

public class Qualifier
implements Comparable<Object> {
    private final String name;
    public final Arg arg;
    public final String propertyName;
    public final Set<String> tags;

    private Qualifier(String name, String propertyName, Arg arg, String ... tags) {
        this.name = name;
        this.propertyName = propertyName;
        this.arg = arg;
        this.tags = tags.length > 0 ? Collections.unmodifiableSet(new HashSet<String>(Arrays.asList(tags))) : Collections.emptySet();
    }

    public String toString() {
        return "[" + (this.name != null ? this.name : "") + ":" + this.propertyName + "]";
    }

    public String getOptionString() {
        if (this.name == null) {
            return null;
        }
        return "-" + this.name;
    }

    @Override
    public int compareTo(Object o) {
        return this.toString().compareTo(o.toString());
    }

    static /* synthetic */ String access$100(Qualifier x0) {
        return x0.name;
    }

    public static class DirectiveQualifier
    extends Qualifier {
        public final Directive task;

        private DirectiveQualifier(String name, Arg.Single arg, Directive task) {
            super(name, (String)null, (Arg)arg, new String[0]);
            if (task == null) {
                throw new NullPointerException();
            }
            this.task = task;
        }
    }

    public static class Group {
        private final Map<String, Qualifier> map = new LinkedHashMap<String, Qualifier>();
        private final Map<String, Qualifier> propertyMap = new HashMap<String, Qualifier>();

        public Group() {
        }

        public Group(Group ... copyFrom) {
            for (Group g : copyFrom) {
                this.map.putAll(g.map);
                this.propertyMap.putAll(g.propertyMap);
            }
        }

        public void add(String name, String propertyName, Arg arg, String ... tags) {
            assert (name.equals(name.toLowerCase())) : name;
            Qualifier q = new Qualifier(name, propertyName, arg, tags);
            Qualifier displaced = this.map.put(name, q);
            assert (displaced == null) : Qualifier.access$100(displaced);
            displaced = this.propertyMap.put(propertyName, q);
            assert (displaced == null) : displaced.propertyName;
        }

        public void add(String[] names, String propertyName, Arg arg, String ... tags) {
            assert (names.length > 0);
            this.add(names[0], propertyName, arg, tags);
            for (int i = 1; i < names.length; ++i) {
                String name = names[i];
                Qualifier displaced = this.map.put(name, new Qualifier(name, propertyName, arg, tags));
                assert (displaced == null) : Qualifier.access$100(displaced);
            }
        }

        public Qualifier getForOption(String name) {
            return this.map.get(name);
        }

        public Qualifier getForProperty(String propertyName) {
            return this.propertyMap.get(propertyName);
        }

        public Collection<Qualifier> getAllOptions() {
            return this.map.values();
        }

        public void addD(String name, Directive task) {
            assert (name.equals(name.toLowerCase())) : name;
            DirectiveQualifier q = new DirectiveQualifier(name, null, task);
            Qualifier displaced = this.map.put(name, q);
            assert (displaced == null) : Qualifier.access$100(displaced);
        }

        public void addD(String[] names, Directive task) {
            for (String name : names) {
                this.addD(name, task);
            }
        }

        public void addD(String name, Directive task, Arg.Single arg) {
            assert (name.equals(name.toLowerCase())) : name;
            DirectiveQualifier q = new DirectiveQualifier(name, arg, task);
            Qualifier displaced = this.map.put(name, q);
            assert (displaced == null) : Qualifier.access$100(displaced);
        }

        public void addD(String[] names, Directive task, Arg.Single arg) {
            for (String name : names) {
                this.addD(name, task, arg);
            }
        }

        public Set<String> getAllPropertyNames() {
            return this.propertyMap.keySet();
        }
    }

    public static abstract class Arg {
        public abstract String getTypeString();

        public static final class Helpers {
            public static final Single PRaw = new Raw(){};
            public static final Single PReadPath = new Path(Path.Type.Any, true);
            public static final Single PReadFile = new Path(Path.Type.File, true);
            public static final Single PReadDir = new Path(Path.Type.Dir, true);
            public static final Single PWriteFile = new Path(Path.Type.Dir, false);
            public static final Single PWriteDir = new Path(Path.Type.Dir, false);

            public static Arg PList(Single p) {
                return new List(p, p.getSplitDelimiter(), p.getJoinDelimiter());
            }

            public static Arg PList(Single p, Pattern splitDelimiter, String joinDelimiter) {
                return new List(p, splitDelimiter, joinDelimiter);
            }

            public static Single PEnum(String ... options) {
                return new Enum(options);
            }

            public static Single PEnumC(String ... options) {
                return new Enum(true, options);
            }

            private Helpers() {
            }
        }

        public class ChooseRaw
        extends Raw {
            String[] options;

            public ChooseRaw(String[] options) {
                this.options = options;
            }

            private ChooseRaw() {
            }

            @Override
            public String getTypeString() {
                return "string";
            }
        }

        public static class Raw
        extends Single {
            @Override
            public String getTypeString() {
                return "string";
            }
        }

        public static class List
        extends Arg {
            public final Single element;
            public final Pattern splitDelimiter;
            public final String joinDelimiter;

            public List(Single element, Pattern splitDelimiter, String joinDelimiter) {
                this.element = element;
                this.splitDelimiter = splitDelimiter;
                this.joinDelimiter = joinDelimiter;
            }

            @Override
            public String getTypeString() {
                return this.element.getTypeString() + " ...";
            }
        }

        public static class Path
        extends Single {
            public final Type type;
            public final boolean mustExist;

            public Path(Type type, boolean mustExist) {
                this.type = type;
                this.mustExist = mustExist;
            }

            @Override
            public Pattern getSplitDelimiter() {
                return Pattern.compile(Pattern.quote(File.pathSeparator));
            }

            @Override
            public String getJoinDelimiter() {
                return File.pathSeparator;
            }

            @Override
            public String getTypeString() {
                switch (this.type) {
                    case Dir: {
                        return "directory";
                    }
                    case File: {
                        return "file";
                    }
                }
                return "path";
            }

            public static enum Type {
                Any,
                File,
                Dir;

            }
        }

        public static class Enum
        extends Single {
            private final Set<String> options;
            private final boolean caseSensitive;

            public Enum(String ... options) {
                this(false, options);
            }

            public Enum(boolean caseSensitive, String ... options) {
                this.caseSensitive = caseSensitive;
                this.options = new LinkedHashSet<String>();
                for (String option : options) {
                    if (!caseSensitive) {
                        option = option.toLowerCase();
                    }
                    boolean added = this.options.add(option);
                    assert (added) : "Option = " + option + ", All = " + Arrays.toString(options);
                }
            }

            public boolean isValidOption(String value) {
                if (!this.caseSensitive) {
                    value = value.toLowerCase();
                }
                return this.options.contains(value);
            }

            @Override
            public String getTypeString() {
                return "\"" + StringUtil.join(this.options, "\" | \"") + "\"";
            }
        }

        public static abstract class Single
        extends Arg {
            public Pattern getSplitDelimiter() {
                return CommandLineParser.PROPERTY_SEPARATOR_PATTERN;
            }

            public String getJoinDelimiter() {
                return ":";
            }
        }
    }
}

