/*
 * Decompiled with CFR 0.152.
 */
package com.fortify.util.filevisitor;

import com.fortify.util.filevisitor.IterativeFileVisitor;
import com.fortify.util.filevisitor.RecursiveFileVisitor;
import java.io.File;
import java.io.FileFilter;

public abstract class FileVisitor {
    protected long count;

    public long getCount() {
        return this.count;
    }

    protected FileVisitor() {
    }

    protected abstract void process(File var1);

    protected abstract void doTraverse(File var1, FileFilter var2);

    public void traverse(File file) {
        FileFilter filter = new FileFilter(){

            @Override
            public boolean accept(File pathname) {
                return true;
            }
        };
        this.traverse(file, filter);
    }

    public void traverse(File file, FileFilter filter) {
        this.count = 0L;
        this.doTraverse(file, filter);
    }

    public void doProcess(File file, FileFilter filter) {
        if (filter.accept(file)) {
            ++this.count;
            this.process(file);
        }
    }

    public static void main(String[] args) {
        boolean verb = false;
        String fileName = null;
        for (int i = 0; i < args.length; ++i) {
            String arg = args[i];
            if (arg.equalsIgnoreCase("-v")) {
                verb = true;
                continue;
            }
            fileName = arg;
        }
        if (fileName == null) {
            return;
        }
        File file = new File(fileName);
        final boolean verbose = verb;
        RecursiveFileVisitor recursiveVisitor = new RecursiveFileVisitor(){

            @Override
            public void process(File file) {
                if (verbose) {
                    System.out.println("\t" + file.getAbsolutePath());
                }
            }
        };
        IterativeFileVisitor iterativeVisitor = new IterativeFileVisitor(){

            @Override
            public void process(File file) {
                if (verbose) {
                    System.out.println("\t" + file.getAbsolutePath());
                }
            }
        };
        System.out.println("\nTraversing files Iteratively:");
        long start = System.currentTimeMillis();
        recursiveVisitor.traverse(file);
        long stop = System.currentTimeMillis() - start;
        System.out.println("Traversed " + recursiveVisitor.getCount() + " files in " + stop + " milliseconds \n");
        System.out.println("\nTraversing files Recursively:");
        start = System.currentTimeMillis();
        iterativeVisitor.traverse(file);
        stop = System.currentTimeMillis() - start;
        System.out.println("Traversed " + iterativeVisitor.getCount() + " files in " + stop + " milliseconds \n");
    }
}

