/*
 * Decompiled with CFR 0.152.
 */
package com.fortify.util.filevisitor;

import com.fortify.util.filevisitor.FileVisitor;
import java.io.File;
import java.io.FileFilter;
import java.util.LinkedList;

public abstract class IterativeFileVisitor
extends FileVisitor {
    @Override
    protected void doTraverse(File file, FileFilter filter) {
        File currentDir;
        LinkedList<File> directories = new LinkedList<File>();
        if (file == null) {
            return;
        }
        if (file.isFile()) {
            this.doProcess(file, filter);
            return;
        }
        directories.add(file);
        while ((currentDir = (File)directories.getFirst()) != null) {
            this.doProcess(file, filter);
            File[] children = currentDir.listFiles();
            for (int i = 0; i < children.length; ++i) {
                File child = children[i];
                if (child.isFile()) {
                    this.doProcess(file, filter);
                }
                if (!child.isDirectory()) continue;
                directories.addLast(child);
            }
        }
    }
}

