/*
 * Decompiled with CFR 0.152.
 */
package com.fortify.util.ide;

import com.fortify.logging.ILogger;
import com.fortify.logging.LoggerConfig;
import com.fortify.messaging.MessageManager;
import com.fortify.messaging.MessageReceiver;
import com.fortify.system.Version;
import com.fortify.util.CommonPropertyKeys;
import com.fortify.util.InstallationConfiguration;
import com.fortify.util.PropertyKey;
import com.fortify.util.SystemUtil;
import java.io.File;
import java.util.Arrays;
import java.util.Locale;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.Properties;
import java.util.ResourceBundle;
import org.apache.logging.log4j.Level;

public abstract class IDEInitializationUtil {
    static ILogger logger = MessageManager.getLogger(IDEInitializationUtil.class);

    protected abstract String[] getMessageBundles();

    protected abstract String getProductType();

    protected abstract String getLoggerName();

    protected abstract void initLogger(LoggerConfig var1);

    protected abstract void doReportInit(boolean var1, String var2);

    protected abstract void handleHomeIsSet();

    protected abstract PropertyKey getDebugPropertyName();

    public void initIDE(String[] args) {
        this.initIDE(args, null);
    }

    public void initIDE(String[] args, MessageReceiver defaultMessageReceiver) {
        this.initializeProductType();
        this.handleHomeIsSet();
        for (String next : this.getMessageBundles()) {
            this.addResourceBundle(next, this.getClass().getClassLoader());
        }
        String overriddenProperties = this.overrideProperties();
        boolean debug = this.checkIfLogDebugEnabled(args);
        this.setupLogging(debug, this.getLoggerName(), this.getLogFilename(), defaultMessageReceiver);
        this.doReportInit(debug, overriddenProperties);
    }

    protected void initializeProductType() {
        InstallationConfiguration.setProductType(this.getProductType() + this.getProductVersion());
    }

    protected String getProductVersion() {
        return Version.getMajorMinorDotPatchVersion(Version.getVersion(Version.Product.PROJECT));
    }

    protected String getLogFilename() {
        return IDEInitializationUtil.removeUnfriendlySymbols(this.getProductType()) + ".log";
    }

    protected String overrideProperties() {
        StringBuilder results = new StringBuilder();
        Properties current = SystemUtil.getProperties();
        Properties system = System.getProperties();
        for (Map.Entry<Object, Object> entry : current.entrySet()) {
            Object key = entry.getKey();
            Object value = entry.getValue();
            if (!system.containsKey(key)) continue;
            results.append('\t').append('\"').append(key).append('=').append(value).append("\" -> \"").append(key).append('=').append(system.get(key)).append('\"').append('\n');
            current.setProperty((String)key, (String)system.get(key));
        }
        return results.toString();
    }

    private void addResourceBundle(String bundleName, ClassLoader loader) throws MissingResourceException {
        ResourceBundle newBundle;
        Locale locale = SystemUtil.getFortifyLocale();
        try {
            newBundle = ResourceBundle.getBundle("messages/" + bundleName, locale, loader);
        }
        catch (MissingResourceException mre) {
            newBundle = ResourceBundle.getBundle(bundleName, locale, loader);
        }
        MessageManager.addResourceBundle(newBundle, bundleName);
    }

    private boolean checkIfLogDebugEnabled(String[] args) {
        boolean debug = false;
        boolean bl = debug = SystemUtil.getBooleanProperty(this.getDebugPropertyName()) ? true : SystemUtil.getBooleanProperty(CommonPropertyKeys.PK_DEBUG);
        return debug ? true : Arrays.asList(args).contains("-debug") || Arrays.asList(args).contains("-fortifydebug");
    }

    private void setupLogging(boolean debug, String loggerName, String logFilename, MessageReceiver defaultMessageReceiver) {
        if (defaultMessageReceiver != null) {
            MessageManager.addMessageReceiver(defaultMessageReceiver);
        }
        System.setProperty("log4j2.loggerContextFactory", "org.apache.logging.log4j.core.impl.Log4jContextFactory");
        System.setProperty(CommonPropertyKeys.PK_LOG_TO_CONSOLE.key, "false");
        String logFile = InstallationConfiguration.getProductLogDirectory() + File.separator + this.getLogFilename();
        LoggerConfig loggerConfig = new LoggerConfig(this.getLoggerName(), debug ? Level.ALL : Level.INFO, logFile, true, false);
        this.initLogger(loggerConfig);
    }

    public static String removeUnfriendlySymbols(String productType) {
        if (productType != null) {
            return productType.replaceAll("[^\\w]", "");
        }
        return null;
    }
}

