/*
 * Decompiled with CFR 0.152.
 */
package com.fortify.util.password;

import com.fortify.util.password.WeakPasswordProtector;
import java.security.SecureRandom;

public final class SafePasswordGenerator {
    private static final char[] VALID_CHARS = "abcdefghjkmnpqrstuvwxyzABCDEFGHJKMNPQRSTUVWXYZ23456789!@#$%-+".toCharArray();

    private SafePasswordGenerator() {
    }

    public static String getClearPassword() {
        String clearPw = null;
        int maxPasswordLength = 10;
        for (int i = 0; i < 10000; ++i) {
            clearPw = SafePasswordGenerator.generate(10);
            if (!WeakPasswordProtector.getDefaultProtector().isWeakPassword(clearPw)) break;
            clearPw = null;
        }
        if (clearPw == null) {
            throw new IllegalStateException("Gave up trying to generate strong password");
        }
        return clearPw;
    }

    private static String generate(int length) {
        char[] result = new char[length];
        SecureRandom r = new SecureRandom();
        for (int i = 0; i < length; ++i) {
            result[i] = VALID_CHARS[(int)(r.nextDouble() * (double)VALID_CHARS.length)];
        }
        return new String(result);
    }
}

