/*
 * Decompiled with CFR 0.152.
 */
package com.fortify.util.password;

import java.util.Arrays;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;

public class WeakPasswordProtector {
    private static final int DEFAULT_MIN_PASSWORD_LENGTH = 8;
    private final List<String> checkRules = new LinkedList<String>();
    private int minPasswordLength;

    public WeakPasswordProtector() {
        this.setDefaultCheckRules();
        this.innerSetMinPasswordLength(8);
    }

    public WeakPasswordProtector(int minPasswordLength) {
        this.setDefaultCheckRules();
        this.innerSetMinPasswordLength(minPasswordLength);
    }

    private void setDefaultCheckRules() {
        this.innerSetCheckRules(Arrays.asList("(.*)([A-Z])(.*)", "(.*)([a-z])(.*)", "(.*)([0-9])(.*)", "(.*)([^A-Za-z0-9])(.*)"));
    }

    public WeakPasswordProtector(List<String> checkRules, int minPasswordLength) {
        this.innerSetCheckRules(checkRules);
        this.innerSetMinPasswordLength(minPasswordLength);
    }

    private void innerSetCheckRules(List<String> checkRulesVal) {
        this.checkRules.clear();
        if (checkRulesVal != null) {
            for (String checkRule : checkRulesVal) {
                if (checkRule == null) continue;
                this.checkRules.add(checkRule);
            }
        }
    }

    private void innerSetMinPasswordLength(int minPasswordLengthVal) {
        if (minPasswordLengthVal < 0) {
            throw new IllegalArgumentException("minPasswordLengthVal must be equals or greater then zero.");
        }
        this.minPasswordLength = minPasswordLengthVal;
    }

    public int getMinPasswordLength() {
        return this.minPasswordLength;
    }

    public boolean isWeakPassword(String password) {
        String checkRule;
        if (password == null) {
            return true;
        }
        boolean result = false;
        Iterator<String> iterator = this.checkRules.iterator();
        while (iterator.hasNext() && !(result = !password.matches(checkRule = iterator.next()))) {
        }
        if (!result) {
            result = password.length() < this.minPasswordLength;
        }
        return result;
    }

    public static WeakPasswordProtector getDefaultProtector() {
        return DefaultProtectorKeeper.DEFAULT_PROTECTOR;
    }

    private static class DefaultProtectorKeeper {
        public static WeakPasswordProtector DEFAULT_PROTECTOR = new WeakPasswordProtector();

        private DefaultProtectorKeeper() {
        }
    }
}

