/*
 * Decompiled with CFR 0.152.
 */
package com.fortify.util.signature;

import com.fortify.logging.ILogger;
import com.fortify.logging.ILoggerMin;
import com.fortify.messaging.Localization;
import com.fortify.messaging.MessageManager;
import com.fortify.util.FVDLSignatureUtil;
import com.fortify.util.signature.EntrySignatureInfo;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;

public class SignatureInfo {
    static ILogger logger = MessageManager.getLogger(SignatureInfo.class);
    private Set rulesFiles = new HashSet();
    private Set analysisSignatures = new HashSet();
    private static Map nameMap = new HashMap();
    private static List analysisEntryNames = Arrays.asList("audit.fvdl", "rta.fvdl", "pta.fvdl", "runtime.fvdl");
    private static final String MAC = ".mac";

    private SignatureInfo() {
    }

    public boolean isFullySigned() {
        return this.isAllValidAnalysisSignatures() && this.isAllValidRulesSignatures();
    }

    public boolean isAllValidAnalysisSignatures() {
        return this.isAllEntrySignatureValid(this.analysisSignatures);
    }

    public static SignatureInfo getSignature(ZipFile fpr) {
        SignatureInfo info = new SignatureInfo();
        info.checkSignature(fpr);
        return info;
    }

    public boolean isAllValidRulesSignatures() {
        return this.isAllEntrySignatureValid(this.rulesFiles);
    }

    private boolean isAllEntrySignatureValid(Set rulesFiles1) {
        if (rulesFiles1.isEmpty()) {
            return true;
        }
        for (EntrySignatureInfo rulesSignatureInfo : rulesFiles1) {
            if (rulesSignatureInfo.isValidSignature()) continue;
            return false;
        }
        return true;
    }

    public boolean hasRulesSignature() {
        return this.entryListHasSignatures(this.rulesFiles);
    }

    private boolean entryListHasSignatures(Set rulesFiles1) {
        for (EntrySignatureInfo rulesSignatureInfo : rulesFiles1) {
            if (!rulesSignatureInfo.hasSignature()) continue;
            return true;
        }
        return !rulesFiles1.isEmpty();
    }

    public boolean hasSignature() {
        return this.hasAnalysisSignatures() || this.hasRulesSignature();
    }

    public boolean hasAnalysisSignatures() {
        return this.entryListHasSignatures(this.analysisSignatures);
    }

    private void checkSignature(ZipFile fpr) {
        Enumeration<? extends ZipEntry> zipEntries = fpr.entries();
        while (zipEntries.hasMoreElements()) {
            InputStream sig;
            InputStream source;
            ZipEntry sigEntry;
            ZipEntry e = zipEntries.nextElement();
            String name = e.getName();
            if (name.startsWith("rules/") && !name.endsWith(MAC) && !name.endsWith("/")) {
                EntrySignatureInfo ruleSigInfo = new EntrySignatureInfo(name, name);
                sigEntry = fpr.getEntry(name + MAC);
                if (sigEntry != null) {
                    ruleSigInfo.setHasSignature(true);
                    try {
                        source = fpr.getInputStream(e);
                        sig = fpr.getInputStream(sigEntry);
                        ruleSigInfo.setValidSignature(FVDLSignatureUtil.verify(source, sig));
                    }
                    catch (IOException e1) {
                        logger.log(ILoggerMin.Level.DEBUG, ILoggerMin.Marker.LOG, "Error retrieving signature info for rules entry " + name, (Throwable)e1);
                    }
                }
                this.rulesFiles.add(ruleSigInfo);
            }
            if (!analysisEntryNames.contains(name)) continue;
            EntrySignatureInfo analysisEntrySigInfo = new EntrySignatureInfo(name, (String)nameMap.get(name));
            sigEntry = fpr.getEntry(name + MAC);
            if (sigEntry != null) {
                analysisEntrySigInfo.setHasSignature(true);
                try {
                    source = fpr.getInputStream(e);
                    sig = fpr.getInputStream(sigEntry);
                    analysisEntrySigInfo.setValidSignature(FVDLSignatureUtil.verify(source, sig));
                }
                catch (IOException e1) {
                    logger.log(ILoggerMin.Level.DEBUG, ILoggerMin.Marker.LOG, "Error retrieving signature info for rules entry " + name, (Throwable)e1);
                }
            }
            this.analysisSignatures.add(analysisEntrySigInfo);
        }
    }

    public boolean isPartiallySigned() {
        return this.hasAnalysisSignatures() && this.isAllValidAnalysisSignatures() || this.hasRulesSignature() && this.isAllValidRulesSignatures();
    }

    public Set getRulesSignatures() {
        return this.rulesFiles;
    }

    public Set getAnalysisSignatures() {
        return this.analysisSignatures;
    }

    public void merge(SignatureInfo signature) {
        this.analysisSignatures.removeAll(signature.getAnalysisSignatures());
        this.analysisSignatures.addAll(signature.getAnalysisSignatures());
        this.rulesFiles.removeAll(signature.getRulesSignatures());
        this.rulesFiles.addAll(signature.getRulesSignatures());
    }

    static {
        nameMap.put("audit.fvdl", Localization.getLocalString(307, new Object[0]));
        nameMap.put("rta.fvdl", Localization.getLocalString(306, new Object[0]));
        nameMap.put("pta.fvdl", Localization.getLocalString(305, new Object[0]));
        nameMap.put("runtime.fvdl", Localization.getLocalString(310, new Object[0]));
    }
}

