/*
 * Decompiled with CFR 0.152.
 */
package com.fortify.util.webapp;

import com.fortify.util.FileUtil;
import java.io.File;

public class WarInfo {
    private File warFile;
    private boolean hasWebInf = false;
    private boolean hasWebXml = false;
    private boolean hasLib = false;
    private boolean hasClasses = false;

    public WarInfo(File warFile) {
        this.warFile = warFile;
        this.hasWebInf = new File(warFile, "WEB-INF").exists();
        if (this.hasWebInf) {
            this.hasWebXml = new File(new File(warFile, "WEB-INF"), "web.xml").exists();
            this.hasLib = new File(new File(warFile, "WEB-INF"), "lib").exists();
            this.hasClasses = new File(new File(warFile, "WEB-INF"), "classes").exists();
        }
    }

    public boolean hasWebInf() {
        return this.hasWebInf;
    }

    public boolean hasWebXml() {
        return this.hasWebXml;
    }

    public boolean hasWebLib() {
        return this.hasLib;
    }

    public boolean hasWebClasses() {
        return this.hasClasses;
    }

    public String getPathDescString(File baseDir) {
        return FileUtil.getRelativePath(baseDir, this.warFile);
    }
}

