/*
 * Decompiled with CFR 0.152.
 */
package com.fortify.util.webapp;

import com.fortify.util.FileUtil;
import com.fortify.util.ZipUtil;
import com.fortify.util.webapp.EarInfo;
import com.fortify.util.webapp.WarInfo;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

public class WebappValidator {
    private String webappName = null;
    private File originalFile = null;
    private File workingDir = null;
    private boolean isEar = false;
    private boolean isWar = false;
    private boolean exists = false;
    private List warInfos = new ArrayList();

    public static void main(String[] args) {
        if (args.length != 1) {
            WebappValidator.usage();
        }
        boolean valid = true;
        try {
            WebappValidator wav = new WebappValidator(args[0]);
            List warInfos = wav.getWarInfos();
            for (int i = 0; i < warInfos.size(); ++i) {
                WarInfo warInfo = (WarInfo)warInfos.get(i);
                if (!warInfo.hasWebInf()) {
                    valid = false;
                    System.out.println("WARNING: War does not contain \"WEB-INF" + File.separator + "\": " + warInfo.getPathDescString(wav.getWorkingDir().getParentFile()));
                }
                if (warInfo.hasWebXml()) continue;
                valid = false;
                System.out.println("WARNING: War does not contain \"WEB-INF" + File.separator + "web.xml\": " + warInfo.getPathDescString(wav.getWorkingDir().getParentFile()));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (valid) {
            System.out.println("Webapp has passed validation.");
        } else {
            System.out.println("WARNING: Webapp has failed validation.");
        }
    }

    public WebappValidator(String webappName) throws IOException {
        this.webappName = webappName;
        this.originalFile = new File(webappName);
        if (this.originalFile.exists()) {
            this.exists = true;
            File tempDir = FileUtil.makeTempDirectory("fortify", null);
            this.workingDir = new File(tempDir, this.originalFile.getName());
            if (this.originalFile.isDirectory()) {
                FileUtil.copy(this.originalFile, this.workingDir);
            } else {
                FileUtil.copy(this.originalFile, tempDir);
            }
            ZipUtil.explodeWebappInPlace(this.workingDir);
            if (ZipUtil.isEar(this.workingDir)) {
                this.isEar = true;
                EarInfo earInfo = new EarInfo(this.workingDir);
                this.warInfos = earInfo.getWarInfos();
            } else {
                this.isWar = true;
                this.warInfos.add(new WarInfo(this.workingDir));
            }
            FileUtil.deleteDirectoryStructure(tempDir);
        }
    }

    public List getWarInfos() {
        return this.warInfos;
    }

    public File getWorkingDir() {
        return this.workingDir;
    }

    public boolean exists() {
        return this.exists;
    }

    private static void usage() {
        System.out.println("Usage: WebappValidator <webApp>");
        System.exit(-1);
    }
}

