/*
 * Decompiled with CFR 0.152.
 */
package com.fortify.xml;

import com.fortify.messaging.MessageManager;
import com.fortify.util.StringUtil;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Stack;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Unmarshaller;
import javax.xml.bind.ValidationEventHandler;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import javax.xml.transform.Source;
import javax.xml.transform.sax.SAXSource;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.DTDHandler;
import org.xml.sax.EntityResolver;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.SAXNotRecognizedException;
import org.xml.sax.SAXNotSupportedException;
import org.xml.sax.XMLReader;

public class HybridJaxbParser {
    private final ContentHandler defaultContentHandler;
    private String defaultNamespace;
    private final ElementHandler handler;
    private final InnerFilter filter;
    private final String jaxbPackage;
    private ClassLoader classLoader = null;
    private ValidationEventHandler validationEventHandler;
    private final List<String> ignoreNamespaceElements = new ArrayList<String>();

    public HybridJaxbParser(String jaxbPackage, ElementHandler handler, Filter filter) {
        this(jaxbPackage, handler, filter, null);
    }

    public HybridJaxbParser(String jaxbPackage, ElementHandler handler, Filter filter, ContentHandler defaultContentHandler) {
        this(jaxbPackage, handler, filter, defaultContentHandler, null);
    }

    public HybridJaxbParser(String jaxbPackage, ElementHandler handler, Filter filter, ContentHandler defaultContentHandler, String defaultNamespace) {
        this(jaxbPackage, handler, filter, defaultContentHandler, defaultNamespace, null);
    }

    public HybridJaxbParser(String jaxbPackage, ElementHandler handler, Filter filter, ContentHandler defaultContentHandler, String defaultNamespace, String[] ignoreNamespaceElements) {
        this.handler = handler;
        this.filter = filter instanceof InnerFilter ? (InnerFilter)filter : new InnerFilterWrapper(filter);
        this.jaxbPackage = jaxbPackage;
        this.defaultContentHandler = defaultContentHandler;
        this.defaultNamespace = defaultNamespace;
        if (ignoreNamespaceElements != null) {
            this.ignoreNamespaceElements.addAll(Arrays.asList(ignoreNamespaceElements));
        }
    }

    public void setJaxbClassLoader(ClassLoader classLoader) {
        this.classLoader = classLoader;
    }

    private static void saxSetFeature(SAXParserFactory pf, String feature, boolean value) {
        try {
            pf.setFeature(feature, value);
        }
        catch (ParserConfigurationException parserConfigurationException) {
        }
        catch (SAXNotRecognizedException sAXNotRecognizedException) {
        }
        catch (SAXNotSupportedException sAXNotSupportedException) {
            // empty catch block
        }
    }

    public void setEventHandler(ValidationEventHandler eventHandler) {
        this.validationEventHandler = eventHandler;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void runParserSAX(InputSource is) throws ParserConfigurationException, SAXException, JAXBException, IOException {
        SAXParserFactory spFactory = SAXParserFactory.newInstance();
        HybridJaxbParser.saxSetFeature(spFactory, "http://xml.org/sax/features/resolve-dtd-uris", false);
        HybridJaxbParser.saxSetFeature(spFactory, "http://xml.org/sax/features/validation", false);
        HybridJaxbParser.saxSetFeature(spFactory, "http://xml.org/sax/features/external-general-entities", false);
        HybridJaxbParser.saxSetFeature(spFactory, "http://xml.org/sax/features/external-parameter-entities", false);
        HybridJaxbParser.saxSetFeature(spFactory, "http://apache.org/xml/features/nonvalidating/load-dtd-grammar", false);
        HybridJaxbParser.saxSetFeature(spFactory, "http://apache.org/xml/features/nonvalidating/load-external-dtd", false);
        spFactory.setValidating(false);
        spFactory.setNamespaceAware(true);
        SAXParser sp = spFactory.newSAXParser();
        final XMLReader r = sp.getXMLReader();
        final JaxbDriver driver = new JaxbDriver();
        Thread driverThread = new Thread((Runnable)driver, "HybridJaxbParser.JaxbDriver");
        driverThread.setDaemon(true);
        driverThread.start();
        try {
            try {
                driver.setup();
            }
            catch (InterruptedException e) {
                MessageManager.logWarn("Unexpected thread interrupt", e);
            }
            JAXBContext jc = this.classLoader == null ? JAXBContext.newInstance((String)this.jaxbPackage) : JAXBContext.newInstance((String)this.jaxbPackage, (ClassLoader)this.classLoader);
            final Unmarshaller u = jc.createUnmarshaller();
            if (this.validationEventHandler != null) {
                u.setEventHandler(this.validationEventHandler);
            }
            final AtomicBoolean filterInnerElements = new AtomicBoolean(false);
            ContentHandler ch = new ContentHandler(){
                private final ArrayList<String> path = new ArrayList();
                private ContentHandler relay = null;
                private Locator loc = null;
                private int relayDepth;
                private int ignoreDepth;
                private final Stack<String> prefixStack = new Stack();
                private final Stack<String> uriStack = new Stack();
                {
                    if (HybridJaxbParser.this.defaultNamespace != null) {
                        this.prefixStack.push("");
                        this.uriStack.push(HybridJaxbParser.this.defaultNamespace);
                    }
                }

                @Override
                public void setDocumentLocator(Locator locator) {
                    this.loc = locator;
                    if (this.relay != null) {
                        this.relay.setDocumentLocator(locator);
                    } else if (HybridJaxbParser.this.defaultContentHandler != null) {
                        HybridJaxbParser.this.defaultContentHandler.setDocumentLocator(locator);
                    }
                }

                @Override
                public void startDocument() throws SAXException {
                    if (HybridJaxbParser.this.defaultContentHandler != null) {
                        HybridJaxbParser.this.defaultContentHandler.startDocument();
                    }
                }

                @Override
                public void endDocument() throws SAXException {
                    if (HybridJaxbParser.this.defaultContentHandler != null) {
                        HybridJaxbParser.this.defaultContentHandler.endDocument();
                    }
                }

                @Override
                public void startPrefixMapping(String prefix, String uri) throws SAXException {
                    if (this.relay != null) {
                        this.relay.startPrefixMapping(prefix, uri);
                    } else {
                        this.prefixStack.push(prefix);
                        this.uriStack.push(uri);
                        if (HybridJaxbParser.this.defaultContentHandler != null) {
                            HybridJaxbParser.this.defaultContentHandler.startPrefixMapping(prefix, uri);
                        }
                    }
                }

                @Override
                public void endPrefixMapping(String prefix) throws SAXException {
                    if (this.relay != null) {
                        this.relay.endPrefixMapping(prefix);
                    } else {
                        this.prefixStack.pop();
                        this.uriStack.pop();
                        if (HybridJaxbParser.this.defaultContentHandler != null) {
                            HybridJaxbParser.this.defaultContentHandler.endPrefixMapping(prefix);
                        }
                    }
                }

                @Override
                public void startElement(String uriIn, final String localName, final String qName, final Attributes atts) throws SAXException {
                    String uri;
                    this.path.add(qName);
                    String string = uri = StringUtil.isEmpty(uriIn) ? HybridJaxbParser.this.defaultNamespace : uriIn;
                    if (this.relay != null) {
                        if (this.ignoreDepth > 0 || uri != null && HybridJaxbParser.this.ignoreNamespaceElements.contains(uri)) {
                            ++this.ignoreDepth;
                        }
                        if (this.ignoreDepth == 0) {
                            boolean shouldAcceptInner = HybridJaxbParser.this.filter.acceptInner(this.path);
                            if (!shouldAcceptInner) {
                                filterInnerElements.set(true);
                            } else {
                                this.relay.startElement(uri, localName, qName, atts);
                            }
                        }
                        ++this.relayDepth;
                    } else {
                        boolean shouldProcess = HybridJaxbParser.this.filter.accept(this.path);
                        if (HybridJaxbParser.this.handler instanceof FilteredElementHandler) {
                            shouldProcess &= ((FilteredElementHandler)HybridJaxbParser.this.handler).wantElement(this.path, atts);
                        }
                        if (shouldProcess) {
                            this.relayDepth = 1;
                            this.ignoreDepth = 0;
                            SAXSource s = new SAXSource();
                            s.setXMLReader(new XMLReader(){

                                @Override
                                public boolean getFeature(String name) throws SAXNotRecognizedException, SAXNotSupportedException {
                                    return r.getFeature(name);
                                }

                                @Override
                                public void setFeature(String name, boolean value) throws SAXNotRecognizedException, SAXNotSupportedException {
                                    r.setFeature(name, value);
                                }

                                @Override
                                public Object getProperty(String name) throws SAXNotRecognizedException, SAXNotSupportedException {
                                    return r.getProperty(name);
                                }

                                @Override
                                public void setProperty(String name, Object value) throws SAXNotRecognizedException, SAXNotSupportedException {
                                    r.setProperty(name, value);
                                }

                                @Override
                                public void setEntityResolver(EntityResolver resolver) {
                                    throw new UnsupportedOperationException();
                                }

                                @Override
                                public EntityResolver getEntityResolver() {
                                    return r.getEntityResolver();
                                }

                                @Override
                                public void setDTDHandler(DTDHandler handler) {
                                    r.setDTDHandler(handler);
                                }

                                @Override
                                public DTDHandler getDTDHandler() {
                                    return r.getDTDHandler();
                                }

                                @Override
                                public void setContentHandler(ContentHandler handler) {
                                    handler.setDocumentLocator(loc);
                                    relay = handler;
                                }

                                @Override
                                public ContentHandler getContentHandler() {
                                    return relay;
                                }

                                @Override
                                public void setErrorHandler(ErrorHandler handler) {
                                    r.setErrorHandler(handler);
                                }

                                @Override
                                public ErrorHandler getErrorHandler() {
                                    return r.getErrorHandler();
                                }

                                @Override
                                public void parse(InputSource input) throws IOException, SAXException {
                                    relay.startDocument();
                                    if (!prefixStack.isEmpty()) {
                                        Iterator u = uriStack.iterator();
                                        Iterator i = prefixStack.iterator();
                                        while (i.hasNext()) {
                                            relay.startPrefixMapping((String)i.next(), (String)u.next());
                                        }
                                    }
                                    relay.startElement(uri, localName, qName, atts);
                                    try {
                                        driver.parseStart();
                                    }
                                    catch (InterruptedException e) {
                                        MessageManager.logWarn("Unexpected thread interrupt", e);
                                    }
                                }

                                @Override
                                public void parse(String systemId) throws IOException, SAXException {
                                    throw new UnsupportedOperationException();
                                }
                            });
                            try {
                                driver.go(u, s);
                            }
                            catch (JAXBException je) {
                                throw new JAXBExceptionWrapper(je);
                            }
                            catch (InterruptedException ie) {
                                MessageManager.logWarn("Unexpected thread interrupt", ie);
                            }
                        } else if (HybridJaxbParser.this.defaultContentHandler != null) {
                            HybridJaxbParser.this.defaultContentHandler.startElement(uri, localName, qName, atts);
                        }
                    }
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void endElement(String uriIn, String localName, String qName) throws SAXException {
                    block13: {
                        try {
                            String uri;
                            String string = uri = StringUtil.isEmpty(uriIn) ? HybridJaxbParser.this.defaultNamespace : uriIn;
                            if (this.relay != null) {
                                if (this.ignoreDepth == 0 && !filterInnerElements.getAndSet(false)) {
                                    this.relay.endElement(uri, localName, qName);
                                }
                                if (this.ignoreDepth > 0) {
                                    --this.ignoreDepth;
                                }
                                if (--this.relayDepth != 0) break block13;
                                this.relay.endDocument();
                                try {
                                    Object result = driver.parseEnd();
                                    HybridJaxbParser.this.handler.handleElement(result);
                                    break block13;
                                }
                                catch (JAXBException je) {
                                    throw new JAXBExceptionWrapper(je);
                                }
                                catch (InterruptedException ie) {
                                    MessageManager.logWarn("Unexpected thread interrupt", ie);
                                    break block13;
                                }
                                finally {
                                    this.relay = null;
                                }
                            }
                            if (HybridJaxbParser.this.defaultContentHandler != null) {
                                HybridJaxbParser.this.defaultContentHandler.endElement(uri, localName, qName);
                            }
                        }
                        finally {
                            this.path.remove(this.path.size() - 1);
                        }
                    }
                }

                @Override
                public void characters(char[] ch, int start, int length) throws SAXException {
                    if (this.relay != null) {
                        if (this.ignoreDepth == 0 && !filterInnerElements.get()) {
                            this.relay.characters(ch, start, length);
                        }
                    } else if (HybridJaxbParser.this.defaultContentHandler != null) {
                        HybridJaxbParser.this.defaultContentHandler.characters(ch, start, length);
                    }
                }

                @Override
                public void ignorableWhitespace(char[] ch, int start, int length) throws SAXException {
                    if (this.relay != null && !filterInnerElements.get()) {
                        this.relay.ignorableWhitespace(ch, start, length);
                    } else if (HybridJaxbParser.this.defaultContentHandler != null) {
                        HybridJaxbParser.this.defaultContentHandler.ignorableWhitespace(ch, start, length);
                    }
                }

                @Override
                public void processingInstruction(String target, String data) throws SAXException {
                    if (this.relay != null && !filterInnerElements.get()) {
                        this.relay.processingInstruction(target, data);
                    } else if (HybridJaxbParser.this.defaultContentHandler != null) {
                        HybridJaxbParser.this.defaultContentHandler.processingInstruction(target, data);
                    }
                }

                @Override
                public void skippedEntity(String name) throws SAXException {
                    if (this.relay != null && !filterInnerElements.get()) {
                        this.relay.skippedEntity(name);
                    } else if (HybridJaxbParser.this.defaultContentHandler != null) {
                        HybridJaxbParser.this.defaultContentHandler.skippedEntity(name);
                    }
                }
            };
            r.setContentHandler(ch);
            try {
                r.parse(is);
            }
            catch (JAXBExceptionWrapper e) {
                throw e.jaxbException;
            }
        }
        finally {
            driver.dispose();
        }
    }

    private static class InnerFilterWrapper
    implements InnerFilter {
        private Filter delegate;

        public InnerFilterWrapper(Filter filter) {
            this.delegate = filter;
        }

        @Override
        public boolean accept(List<String> path) {
            return this.delegate.accept(path);
        }

        @Override
        public boolean acceptInner(List<String> path) {
            return true;
        }
    }

    public static interface InnerFilter
    extends Filter {
        public boolean acceptInner(List<String> var1);
    }

    public static interface Filter {
        public boolean accept(List<String> var1);
    }

    public static interface FilteredElementHandler
    extends ElementHandler {
        public boolean wantElement(List<String> var1, Attributes var2);
    }

    public static interface ElementHandler {
        public void handleElement(Object var1);
    }

    static class JAXBExceptionWrapper
    extends RuntimeException {
        public final JAXBException jaxbException;

        public JAXBExceptionWrapper(JAXBException jaxbException) {
            super(jaxbException);
            this.jaxbException = jaxbException;
        }
    }

    private static class JaxbDriverDisposeException
    extends IllegalStateException {
        public JaxbDriverDisposeException() {
            super("The JaxbDriver is disposed");
        }
    }

    private static class JaxbDriver
    implements Runnable {
        private final Object monitor = new Object();
        private Unmarshaller u;
        private SAXSource s;
        private Object result;
        private Throwable problem;
        private State currentState = State.INIT;

        private JaxbDriver() {
        }

        private void updateState(State state) {
            if (State.DISPOSE.equals((Object)this.currentState)) {
                if (!State.DISPOSE.equals((Object)state)) {
                    this.monitor.notify();
                    throw new JaxbDriverDisposeException();
                }
            } else {
                this.currentState = state;
            }
            this.monitor.notify();
        }

        private boolean awaitState(State state) throws InterruptedException {
            while (!state.equals((Object)this.currentState) && !State.DISPOSE.equals((Object)this.currentState)) {
                this.monitor.wait();
            }
            return state.equals((Object)this.currentState);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void setup() throws InterruptedException {
            Object object = this.monitor;
            synchronized (object) {
                this.awaitState(State.DRIVER_READY);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void dispose() {
            Object object = this.monitor;
            synchronized (object) {
                this.updateState(State.DISPOSE);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void go(Unmarshaller u, SAXSource s) throws InterruptedException, JAXBException {
            Object object = this.monitor;
            synchronized (object) {
                this.result = null;
                this.problem = null;
                this.u = u;
                this.s = s;
                this.updateState(State.DRIVER_PARSE);
                this.awaitState(State.PARSE_START);
                this.checkProblem();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void parseStart() throws InterruptedException {
            Object object = this.monitor;
            synchronized (object) {
                this.updateState(State.PARSE_START);
                this.awaitState(State.PARSE_DONE);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Object parseEnd() throws InterruptedException, JAXBException {
            Object object = this.monitor;
            synchronized (object) {
                this.updateState(State.PARSE_DONE);
                this.awaitState(State.DRIVER_READY);
                this.checkProblem();
                return this.result;
            }
        }

        private void checkProblem() throws JAXBException {
            if (this.problem != null) {
                if (this.problem instanceof JAXBException) {
                    throw (JAXBException)this.problem;
                }
                if (this.problem instanceof Error) {
                    throw (Error)this.problem;
                }
                if (this.problem instanceof RuntimeException) {
                    throw (RuntimeException)this.problem;
                }
                throw new RuntimeException(this.problem);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            try {
                Object object = this.monitor;
                synchronized (object) {
                    this.updateState(State.DRIVER_READY);
                    while (this.awaitState(State.DRIVER_PARSE)) {
                        try {
                            this.result = this.u.unmarshal((Source)this.s);
                        }
                        catch (JAXBException e) {
                            this.problem = e;
                        }
                        catch (Error e) {
                            this.problem = e;
                        }
                        catch (RuntimeException e) {
                            this.problem = e;
                        }
                        finally {
                            this.updateState(State.DRIVER_READY);
                        }
                    }
                }
            }
            catch (InterruptedException ie) {
                MessageManager.logWarn("Unexpected thread interrupt", ie);
                Object object = this.monitor;
                synchronized (object) {
                    this.updateState(State.DISPOSE);
                }
            }
        }

        private static enum State {
            INIT,
            DRIVER_READY,
            DRIVER_PARSE,
            PARSE_START,
            PARSE_DONE,
            DISPOSE;

        }
    }
}

