/*
 * Decompiled with CFR 0.152.
 */
package com.fortify.xml;

import com.fortify.logging.ILogger;
import com.fortify.logging.ILoggerMin;
import com.fortify.messaging.MessageManager;
import javax.xml.bind.JAXBException;
import javax.xml.bind.ValidationEvent;
import javax.xml.bind.ValidationEventHandler;
import org.xml.sax.SAXParseException;

public class JAXBValidationReporter
implements ValidationEventHandler {
    static ILogger logger = MessageManager.getLogger(JAXBValidationReporter.class);
    public ValidationEvent lastValidationEvent = null;

    public boolean handleEvent(ValidationEvent event) {
        this.lastValidationEvent = event;
        return false;
    }

    public void handleJAXBException(JAXBException e) {
        if (this.lastValidationEvent != null && this.lastValidationEvent.getLocator() != null) {
            logger.log(ILoggerMin.Level.DEBUG, ILoggerMin.Marker.LOG, "Error at line " + this.lastValidationEvent.getLocator().getLineNumber() + ": " + this.lastValidationEvent.getMessage(), (Throwable)e);
        } else if (e.getLinkedException() instanceof SAXParseException) {
            logger.log(ILoggerMin.Level.DEBUG, ILoggerMin.Marker.LOG, ((SAXParseException)e.getLinkedException()).getLineNumber() + ": " + e.getLinkedException().getMessage(), (Throwable)e);
        } else {
            logger.log(ILoggerMin.Level.DEBUG, ILoggerMin.Marker.LOG, "Exception parsing XML", (Throwable)e);
        }
        this.lastValidationEvent = null;
    }
}

